/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.console.command.store.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.activemq.console.command.store.protobuf.QueueEntryPBBase;
import org.apache.activemq.protobuf.Buffer;
import org.apache.activemq.protobuf.CodedInputStream;
import org.apache.activemq.protobuf.CodedOutputStream;
import org.apache.activemq.protobuf.InvalidProtocolBufferException;

public final class QueueEntryPB
extends QueueEntryPBBase<QueueEntryPB> {
    public ArrayList<String> missingFields() {
        ArrayList missingFields = super.missingFields();
        if (!this.hasQueueKey()) {
            missingFields.add("queueKey");
        }
        if (!this.hasQueueSeq()) {
            missingFields.add("queueSeq");
        }
        if (!this.hasMessageKey()) {
            missingFields.add("messageKey");
        }
        return missingFields;
    }

    public void clear() {
        super.clear();
        this.clearQueueKey();
        this.clearQueueSeq();
        this.clearMessageKey();
        this.clearSize();
        this.clearAttachment();
        this.clearRedeliveries();
        this.clearExpiration();
        this.clearMessageLocator();
        this.clearSender();
    }

    public QueueEntryPB clone() {
        return new QueueEntryPB().mergeFrom(this);
    }

    public QueueEntryPB mergeFrom(QueueEntryPB other) {
        if (other.hasQueueKey()) {
            this.setQueueKey(other.getQueueKey());
        }
        if (other.hasQueueSeq()) {
            this.setQueueSeq(other.getQueueSeq());
        }
        if (other.hasMessageKey()) {
            this.setMessageKey(other.getMessageKey());
        }
        if (other.hasSize()) {
            this.setSize(other.getSize());
        }
        if (other.hasAttachment()) {
            this.setAttachment(other.getAttachment());
        }
        if (other.hasRedeliveries()) {
            this.setRedeliveries(other.getRedeliveries());
        }
        if (other.hasExpiration()) {
            this.setExpiration(other.getExpiration());
        }
        if (other.hasMessageLocator()) {
            this.setMessageLocator(other.getMessageLocator());
        }
        if (other.hasSender()) {
            this.getSenderList().addAll(other.getSenderList());
        }
        return this;
    }

    public int serializedSizeUnframed() {
        if (this.memoizedSerializedSize != -1) {
            return this.memoizedSerializedSize;
        }
        int size = 0;
        if (this.hasQueueKey()) {
            size += CodedOutputStream.computeInt64Size((int)1, (long)this.getQueueKey());
        }
        if (this.hasQueueSeq()) {
            size += CodedOutputStream.computeInt64Size((int)2, (long)this.getQueueSeq());
        }
        if (this.hasMessageKey()) {
            size += CodedOutputStream.computeInt64Size((int)3, (long)this.getMessageKey());
        }
        if (this.hasSize()) {
            size += CodedOutputStream.computeInt32Size((int)4, (int)this.getSize());
        }
        if (this.hasAttachment()) {
            size += CodedOutputStream.computeBytesSize((int)5, (Buffer)this.getAttachment());
        }
        if (this.hasRedeliveries()) {
            size += CodedOutputStream.computeInt32Size((int)6, (int)this.getRedeliveries());
        }
        if (this.hasExpiration()) {
            size += CodedOutputStream.computeSInt64Size((int)7, (long)this.getExpiration());
        }
        if (this.hasMessageLocator()) {
            size += CodedOutputStream.computeBytesSize((int)8, (Buffer)this.getMessageLocator());
        }
        if (this.hasSender()) {
            for (Buffer i : this.getSenderList()) {
                size += CodedOutputStream.computeBytesSize((int)9, (Buffer)i);
            }
        }
        this.memoizedSerializedSize = size;
        return size;
    }

    public QueueEntryPB mergeUnframed(CodedInputStream input) throws IOException {
        int tag;
        block12: while (((tag = input.readTag()) & 7) != 4) {
            switch (tag) {
                case 0: {
                    return this;
                }
                default: {
                    continue block12;
                }
                case 8: {
                    this.setQueueKey(input.readInt64());
                    continue block12;
                }
                case 16: {
                    this.setQueueSeq(input.readInt64());
                    continue block12;
                }
                case 24: {
                    this.setMessageKey(input.readInt64());
                    continue block12;
                }
                case 32: {
                    this.setSize(input.readInt32());
                    continue block12;
                }
                case 42: {
                    this.setAttachment(input.readBytes());
                    continue block12;
                }
                case 48: {
                    this.setRedeliveries(input.readInt32());
                    continue block12;
                }
                case 56: {
                    this.setExpiration(input.readSInt64());
                    continue block12;
                }
                case 66: {
                    this.setMessageLocator(input.readBytes());
                    continue block12;
                }
                case 74: 
            }
            this.getSenderList().add(input.readBytes());
        }
        return this;
    }

    public void writeUnframed(CodedOutputStream output) throws IOException {
        if (this.hasQueueKey()) {
            output.writeInt64(1, this.getQueueKey());
        }
        if (this.hasQueueSeq()) {
            output.writeInt64(2, this.getQueueSeq());
        }
        if (this.hasMessageKey()) {
            output.writeInt64(3, this.getMessageKey());
        }
        if (this.hasSize()) {
            output.writeInt32(4, this.getSize());
        }
        if (this.hasAttachment()) {
            output.writeBytes(5, this.getAttachment());
        }
        if (this.hasRedeliveries()) {
            output.writeInt32(6, this.getRedeliveries());
        }
        if (this.hasExpiration()) {
            output.writeSInt64(7, this.getExpiration());
        }
        if (this.hasMessageLocator()) {
            output.writeBytes(8, this.getMessageLocator());
        }
        if (this.hasSender()) {
            for (Buffer i : this.getSenderList()) {
                output.writeBytes(9, i);
            }
        }
    }

    public static QueueEntryPB parseUnframed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (QueueEntryPB)((Object)new QueueEntryPB().mergeUnframed(data).checktInitialized());
    }

    public static QueueEntryPB parseUnframed(Buffer data) throws InvalidProtocolBufferException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeUnframed(data))).checktInitialized());
    }

    public static QueueEntryPB parseUnframed(byte[] data) throws InvalidProtocolBufferException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeUnframed(data))).checktInitialized());
    }

    public static QueueEntryPB parseUnframed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeUnframed(data))).checktInitialized());
    }

    public static QueueEntryPB parseFramed(CodedInputStream data) throws InvalidProtocolBufferException, IOException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeFramed(data))).checktInitialized());
    }

    public static QueueEntryPB parseFramed(Buffer data) throws InvalidProtocolBufferException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeFramed(data))).checktInitialized());
    }

    public static QueueEntryPB parseFramed(byte[] data) throws InvalidProtocolBufferException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeFramed(data))).checktInitialized());
    }

    public static QueueEntryPB parseFramed(InputStream data) throws InvalidProtocolBufferException, IOException {
        return (QueueEntryPB)((Object)((QueueEntryPB)((Object)new QueueEntryPB().mergeFramed(data))).checktInitialized());
    }

    public String toString() {
        return this.toString(new StringBuilder(), "").toString();
    }

    public StringBuilder toString(StringBuilder sb, String prefix) {
        if (this.hasQueueKey()) {
            sb.append(prefix + "queueKey: ");
            sb.append(this.getQueueKey());
            sb.append("\n");
        }
        if (this.hasQueueSeq()) {
            sb.append(prefix + "queueSeq: ");
            sb.append(this.getQueueSeq());
            sb.append("\n");
        }
        if (this.hasMessageKey()) {
            sb.append(prefix + "messageKey: ");
            sb.append(this.getMessageKey());
            sb.append("\n");
        }
        if (this.hasSize()) {
            sb.append(prefix + "size: ");
            sb.append(this.getSize());
            sb.append("\n");
        }
        if (this.hasAttachment()) {
            sb.append(prefix + "attachment: ");
            sb.append(this.getAttachment());
            sb.append("\n");
        }
        if (this.hasRedeliveries()) {
            sb.append(prefix + "redeliveries: ");
            sb.append(this.getRedeliveries());
            sb.append("\n");
        }
        if (this.hasExpiration()) {
            sb.append(prefix + "expiration: ");
            sb.append(this.getExpiration());
            sb.append("\n");
        }
        if (this.hasMessageLocator()) {
            sb.append(prefix + "messageLocator: ");
            sb.append(this.getMessageLocator());
            sb.append("\n");
        }
        if (this.hasSender()) {
            List l = this.getSenderList();
            for (int i = 0; i < l.size(); ++i) {
                sb.append(prefix + "sender[" + i + "]: ");
                sb.append(l.get(i));
                sb.append("\n");
            }
        }
        return sb;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != QueueEntryPB.class) {
            return false;
        }
        return this.equals((QueueEntryPB)((Object)obj));
    }

    public boolean equals(QueueEntryPB obj) {
        if (this.hasQueueKey() ^ obj.hasQueueKey()) {
            return false;
        }
        if (this.hasQueueKey() && this.getQueueKey() != obj.getQueueKey()) {
            return false;
        }
        if (this.hasQueueSeq() ^ obj.hasQueueSeq()) {
            return false;
        }
        if (this.hasQueueSeq() && this.getQueueSeq() != obj.getQueueSeq()) {
            return false;
        }
        if (this.hasMessageKey() ^ obj.hasMessageKey()) {
            return false;
        }
        if (this.hasMessageKey() && this.getMessageKey() != obj.getMessageKey()) {
            return false;
        }
        if (this.hasSize() ^ obj.hasSize()) {
            return false;
        }
        if (this.hasSize() && this.getSize() != obj.getSize()) {
            return false;
        }
        if (this.hasAttachment() ^ obj.hasAttachment()) {
            return false;
        }
        if (this.hasAttachment() && !this.getAttachment().equals(obj.getAttachment())) {
            return false;
        }
        if (this.hasRedeliveries() ^ obj.hasRedeliveries()) {
            return false;
        }
        if (this.hasRedeliveries() && this.getRedeliveries() != obj.getRedeliveries()) {
            return false;
        }
        if (this.hasExpiration() ^ obj.hasExpiration()) {
            return false;
        }
        if (this.hasExpiration() && this.getExpiration() != obj.getExpiration()) {
            return false;
        }
        if (this.hasMessageLocator() ^ obj.hasMessageLocator()) {
            return false;
        }
        if (this.hasMessageLocator() && !this.getMessageLocator().equals(obj.getMessageLocator())) {
            return false;
        }
        if (this.hasSender() ^ obj.hasSender()) {
            return false;
        }
        return !this.hasSender() || this.getSenderList().equals(obj.getSenderList());
    }

    public int hashCode() {
        int rc = -1607636045;
        if (this.hasQueueKey()) {
            rc ^= 0xBE718BAE ^ new Long(this.getQueueKey()).hashCode();
        }
        if (this.hasQueueSeq()) {
            rc ^= 0xBE71A9AE ^ new Long(this.getQueueSeq()).hashCode();
        }
        if (this.hasMessageKey()) {
            rc ^= 0x120B30F8 ^ new Long(this.getMessageKey()).hashCode();
        }
        if (this.hasSize()) {
            rc ^= 0x275421 ^ this.getSize();
        }
        if (this.hasAttachment()) {
            rc ^= 0x1C93543 ^ this.getAttachment().hashCode();
        }
        if (this.hasRedeliveries()) {
            rc ^= 0x755F3E25 ^ this.getRedeliveries();
        }
        if (this.hasExpiration()) {
            rc ^= 0x44E726CF ^ new Long(this.getExpiration()).hashCode();
        }
        if (this.hasMessageLocator()) {
            rc ^= 0xB887AAF ^ this.getMessageLocator().hashCode();
        }
        if (this.hasSender()) {
            rc ^= 0x93650655 ^ this.getSenderList().hashCode();
        }
        return rc;
    }
}

