/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.management;

import java.util.List;
import org.apache.activemq.ActiveMQSession;
import org.apache.activemq.management.JMSSessionStatsImpl;
import org.apache.activemq.management.StatsImpl;
import org.apache.activemq.util.IndentPrinter;

public class JMSConnectionStatsImpl
extends StatsImpl {
    private List sessions;
    private boolean transactional;

    public JMSConnectionStatsImpl(List sessions, boolean transactional) {
        this.sessions = sessions;
        this.transactional = transactional;
    }

    public JMSSessionStatsImpl[] getSessions() {
        Object[] sessionArray = this.sessions.toArray();
        int size = sessionArray.length;
        JMSSessionStatsImpl[] answer = new JMSSessionStatsImpl[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ActiveMQSession session = (ActiveMQSession)sessionArray[i2];
            answer[i2] = session.getSessionStats();
        }
        return answer;
    }

    @Override
    public void reset() {
        super.reset();
        JMSSessionStatsImpl[] stats = this.getSessions();
        int size = stats.length;
        for (int i2 = 0; i2 < size; ++i2) {
            stats[i2].reset();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        JMSSessionStatsImpl[] stats = this.getSessions();
        int size = stats.length;
        for (int i2 = 0; i2 < size; ++i2) {
            stats[i2].setEnabled(enabled);
        }
    }

    public boolean isTransactional() {
        return this.transactional;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("connection{ ");
        JMSSessionStatsImpl[] array = this.getSessions();
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(Integer.toString(i2));
            buffer.append(" = ");
            buffer.append(array[i2]);
        }
        buffer.append(" }");
        return buffer.toString();
    }

    public void dump(IndentPrinter out) {
        out.printIndent();
        out.println("connection {");
        out.incrementIndent();
        JMSSessionStatsImpl[] array = this.getSessions();
        for (int i2 = 0; i2 < array.length; ++i2) {
            JMSSessionStatsImpl sessionStat = array[i2];
            out.printIndent();
            out.println("session {");
            out.incrementIndent();
            sessionStat.dump(out);
            out.decrementIndent();
            out.printIndent();
            out.println("}");
        }
        out.decrementIndent();
        out.printIndent();
        out.println("}");
        out.flush();
    }
}

