/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ObjectHelper;

public abstract class FhirDataformat
extends DataFormatDefinition {
    @XmlTransient
    @Metadata(label="advanced")
    private Object fhirContext;
    @XmlAttribute
    @Metadata(enums="DSTU2,DSTU2_HL7ORG,DSTU2_1,DSTU3,R4", defaultValue="DSTU3")
    private String fhirVersion;
    @XmlAttribute
    private Boolean prettyPrint;
    @XmlTransient
    @Metadata(label="advanced")
    private Object parserErrorHandler;
    @XmlTransient
    @Metadata(label="advanced")
    private Object parserOptions;
    @XmlTransient
    @Metadata(label="advanced")
    private Object preferTypes;
    @XmlTransient
    @Metadata(label="advanced")
    private Object forceResourceId;
    @XmlAttribute
    @Metadata(label="advanced")
    private String serverBaseUrl;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean omitResourceId;
    @XmlAttribute
    @Metadata(label="advanced")
    private Set<String> encodeElementsAppliesToResourceTypes;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean encodeElementsAppliesToChildResourcesOnly;
    @XmlAttribute
    @Metadata(label="advanced")
    private Set<String> encodeElements;
    @XmlAttribute
    @Metadata(label="advanced")
    private Set<String> dontEncodeElements;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean stripVersionsFromReferences;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean overrideResourceIdWithBundleEntryFullUrl;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean summaryMode;
    @XmlAttribute
    @Metadata(label="advanced")
    private Boolean suppressNarratives;
    @XmlAttribute
    @Metadata(label="advanced")
    private List<String> dontStripVersionsFromReferencesAtPaths;

    protected FhirDataformat(String dataFormatName) {
        super(dataFormatName);
    }

    protected FhirDataformat() {
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        Boolean answer;
        if (this.getContentTypeHeader() != null) {
            this.setProperty(camelContext, dataFormat, "contentTypeHeader", this.getContentTypeHeader());
        }
        if (this.getFhirContext() != null) {
            this.setProperty(camelContext, dataFormat, "fhirContext", this.getFhirContext());
        }
        if (this.getFhirVersion() != null) {
            this.setProperty(camelContext, dataFormat, "fhirVersion", this.getFhirVersion());
        }
        if (ObjectHelper.isNotEmpty(this.getDontStripVersionsFromReferencesAtPaths())) {
            this.setProperty(camelContext, dataFormat, "dontStripVersionsFromReferencesAtPaths", this.getDontStripVersionsFromReferencesAtPaths());
        }
        if (ObjectHelper.isNotEmpty(this.getDontEncodeElements())) {
            this.setProperty(camelContext, dataFormat, "dontEncodeElements", this.getDontEncodeElements());
        }
        if (ObjectHelper.isNotEmpty(this.getEncodeElements())) {
            this.setProperty(camelContext, dataFormat, "encodeElements", this.getEncodeElements());
        }
        if (ObjectHelper.isNotEmpty(this.getEncodeElementsAppliesToResourceTypes())) {
            this.setProperty(camelContext, dataFormat, "encodeElementsAppliesToResourceTypes", this.getEncodeElementsAppliesToResourceTypes());
        }
        if (ObjectHelper.isNotEmpty(this.getServerBaseUrl())) {
            this.setProperty(camelContext, dataFormat, "serverBaseUrl", this.getServerBaseUrl());
        }
        if (ObjectHelper.isNotEmpty(this.getForceResourceId())) {
            this.setProperty(camelContext, dataFormat, "forceResourceId", this.getForceResourceId());
        }
        if (ObjectHelper.isNotEmpty(this.getPreferTypes())) {
            this.setProperty(camelContext, dataFormat, "preferTypes", this.getPreferTypes());
        }
        if (ObjectHelper.isNotEmpty(this.getParserOptions())) {
            this.setProperty(camelContext, dataFormat, "parserOptions", this.getParserOptions());
        }
        if (ObjectHelper.isNotEmpty(this.getParserErrorHandler())) {
            this.setProperty(camelContext, dataFormat, "parserErrorHandler", this.getParserErrorHandler());
        }
        if ((answer = ObjectHelper.toBoolean(this.isEncodeElementsAppliesToChildResourcesOnly())) != null) {
            this.setProperty(camelContext, dataFormat, "encodeElementsAppliesToChildResourcesOnly", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.isOmitResourceId())) != null) {
            this.setProperty(camelContext, dataFormat, "omitResourceId", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.isPrettyPrint())) != null) {
            this.setProperty(camelContext, dataFormat, "prettyPrint", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.isSuppressNarratives())) != null) {
            this.setProperty(camelContext, dataFormat, "suppressNarratives", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.isSummaryMode())) != null) {
            this.setProperty(camelContext, dataFormat, "summaryMode", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.getOverrideResourceIdWithBundleEntryFullUrl())) != null) {
            this.setProperty(camelContext, dataFormat, "overrideResourceIdWithBundleEntryFullUrl", answer);
        }
        if ((answer = ObjectHelper.toBoolean(this.getStripVersionsFromReferences())) != null) {
            this.setProperty(camelContext, dataFormat, "stripVersionsFromReferences", answer);
        }
    }

    public Object getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(Object fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public Boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(Boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public Object getParserErrorHandler() {
        return this.parserErrorHandler;
    }

    public void setParserErrorHandler(Object parserErrorHandler) {
        this.parserErrorHandler = parserErrorHandler;
    }

    public Object getParserOptions() {
        return this.parserOptions;
    }

    public void setParserOptions(Object parserOptions) {
        this.parserOptions = parserOptions;
    }

    public Object getPreferTypes() {
        return this.preferTypes;
    }

    public void setPreferTypes(Object preferTypes) {
        this.preferTypes = preferTypes;
    }

    public Object getForceResourceId() {
        return this.forceResourceId;
    }

    public void setForceResourceId(Object forceResourceId) {
        this.forceResourceId = forceResourceId;
    }

    public String getServerBaseUrl() {
        return this.serverBaseUrl;
    }

    public void setServerBaseUrl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public Boolean isOmitResourceId() {
        return this.omitResourceId;
    }

    public void setOmitResourceId(Boolean omitResourceId) {
        this.omitResourceId = omitResourceId;
    }

    public Set<String> getEncodeElementsAppliesToResourceTypes() {
        return this.encodeElementsAppliesToResourceTypes;
    }

    public void setEncodeElementsAppliesToResourceTypes(Set<String> encodeElementsAppliesToResourceTypes) {
        this.encodeElementsAppliesToResourceTypes = encodeElementsAppliesToResourceTypes;
    }

    public Boolean isEncodeElementsAppliesToChildResourcesOnly() {
        return this.encodeElementsAppliesToChildResourcesOnly;
    }

    public void setEncodeElementsAppliesToChildResourcesOnly(Boolean encodeElementsAppliesToChildResourcesOnly) {
        this.encodeElementsAppliesToChildResourcesOnly = encodeElementsAppliesToChildResourcesOnly;
    }

    public Set<String> getEncodeElements() {
        return this.encodeElements;
    }

    public void setEncodeElements(Set<String> encodeElements) {
        this.encodeElements = encodeElements;
    }

    public Set<String> getDontEncodeElements() {
        return this.dontEncodeElements;
    }

    public void setDontEncodeElements(Set<String> dontEncodeElements) {
        this.dontEncodeElements = dontEncodeElements;
    }

    public Boolean getStripVersionsFromReferences() {
        return this.stripVersionsFromReferences;
    }

    public void setStripVersionsFromReferences(Boolean stripVersionsFromReferences) {
        this.stripVersionsFromReferences = stripVersionsFromReferences;
    }

    public Boolean getOverrideResourceIdWithBundleEntryFullUrl() {
        return this.overrideResourceIdWithBundleEntryFullUrl;
    }

    public void setOverrideResourceIdWithBundleEntryFullUrl(Boolean overrideResourceIdWithBundleEntryFullUrl) {
        this.overrideResourceIdWithBundleEntryFullUrl = overrideResourceIdWithBundleEntryFullUrl;
    }

    public Boolean isSummaryMode() {
        return this.summaryMode;
    }

    public void setSummaryMode(Boolean summaryMode) {
        this.summaryMode = summaryMode;
    }

    public Boolean isSuppressNarratives() {
        return this.suppressNarratives;
    }

    public void setSuppressNarratives(Boolean suppressNarratives) {
        this.suppressNarratives = suppressNarratives;
    }

    public List<String> getDontStripVersionsFromReferencesAtPaths() {
        return this.dontStripVersionsFromReferencesAtPaths;
    }

    public void setDontStripVersionsFromReferencesAtPaths(List<String> dontStripVersionsFromReferencesAtPaths) {
        this.dontStripVersionsFromReferencesAtPaths = dontStripVersionsFromReferencesAtPaths;
    }
}

