/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.stomp;

import java.util.HashMap;
import java.util.Map;
import org.apache.activemq.broker.BrokerContext;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.broker.BrokerServiceAware;
import org.apache.activemq.transport.MutexTransport;
import org.apache.activemq.transport.Transport;
import org.apache.activemq.transport.stomp.StompInactivityMonitor;
import org.apache.activemq.transport.stomp.StompTransportFilter;
import org.apache.activemq.transport.tcp.TcpTransportFactory;
import org.apache.activemq.util.IntrospectionSupport;
import org.apache.activemq.wireformat.WireFormat;

public class StompTransportFactory
extends TcpTransportFactory
implements BrokerServiceAware {
    private BrokerContext brokerContext = null;

    protected String getDefaultWireFormatType() {
        return "stomp";
    }

    public Transport compositeConfigure(Transport transport, WireFormat format, Map options) {
        transport = new StompTransportFilter((Transport)transport, format, this.brokerContext);
        IntrospectionSupport.setProperties((Object)transport, (Map)options);
        return super.compositeConfigure(transport, format, options);
    }

    public void setBrokerService(BrokerService brokerService) {
        this.brokerContext = brokerService.getBrokerContext();
    }

    public Transport serverConfigure(Transport transport, WireFormat format, HashMap options) throws Exception {
        MutexTransport mutex = (MutexTransport)(transport = super.serverConfigure(transport, format, options)).narrow(MutexTransport.class);
        if (mutex != null) {
            mutex.setSyncOnCommand(true);
        }
        return transport;
    }

    protected Transport createInactivityMonitor(Transport transport, WireFormat format) {
        StompInactivityMonitor monitor = new StompInactivityMonitor(transport, format);
        StompTransportFilter filter = (StompTransportFilter)transport.narrow(StompTransportFilter.class);
        filter.setInactivityMonitor(monitor);
        return monitor;
    }
}

